% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program Weibullstd.m
function [tau_std, eta_std, eta_iqr, thresholds_std] =  Weibullstd(PF0) 
 
contrasts = PF0(1,:);  % PF0 is the measured psychometric 
                       % function. First row: contrasts; 
                       % Second row: # of correct trials
                       % Third row: # of incorrect trials.
totalTrials = PF0(2, :) + PF0(3, :);
p = PF0(2, :) ./ totalTrials;
Nconditions = size(PF0, 2);

tau0 = []; eta0 = []; thresholds0=[];
for i = 1 : 2000
    resampled_Ncorrect = [ ];
    for j = 1 : Nconditions
        resampled_Ncorrect = [resampled_Ncorrect ...
             binornd(totalTrials(j), p(j))];
    end
    resmapled_Nincorrect = totalTrials - ...
             resampled_Ncorrect;
    
    resampled_PF = [contrasts; resampled_Ncorrect; ...
             resmapled_Nincorrect];
            
   [tau, eta, thresholds, maxLoglikelihood] = ...
             Weibull(resampled_PF);
   if eta > 5
       resampled_PF
   end
   
   tau0 = [tau0; tau];
   eta0 = [eta0; eta];
   thresholds0 = [thresholds0; thresholds];
end

tau_std = std(tau0);
eta_std = std(eta0);
eta_iqr = iqr(eta0);
thresholds_std = std(thresholds0);
